% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grav-data.R
\docType{data}
\name{grav}
\alias{grav}
\title{Arabidopsis QTL data on gravitropism}
\format{An object of class \code{"cross"}; see \code{\link[qtl]{read.cross}}.}
\source{
\href{http://phenome.jax.org/db/q?rtn=projects/projdet&reqprojid=282}{Mouse Phenome Database}
}
\usage{
data(grav)
}
\description{
Data from a QTL experiment on gravitropism in
Arabidopsis, with data on 162 recombinant inbred lines (Ler x
Cvi). The outcome is the root tip angle (in degrees) at two-minute
increments over eight hours.
}
\examples{
data(grav)
times <- attr(grav, "time")
phe <- grav$pheno
\donttest{
iplotCurves(phe, times, phe[,c(61,121)], phe[,c(121,181)],
            chartOpts=list(curves_xlab="Time (hours)", curves_ylab="Root tip angle (degrees)",
                           scat1_xlab="Angle at 2 hrs", scat1_ylab="Angle at 4 hrs",
                           scat2_xlab="Angle at 4 hrs", scat2_ylab="Angle at 6 hrs"))}
}
\references{
Moore CR, Johnson LS, Kwak I-Y, Livny M, Broman KW,
Spalding EP (2013) High-throughput computer vision introduces the
time axis to a quantitative trait map of a plant growth
response. Genetics 195:1077-1086
(\href{http://www.ncbi.nlm.nih.gov/pubmed/23979570}{PubMed})
}
\keyword{datasets}
