% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nf1.R
\docType{data}
\name{nf1}
\alias{nf1}
\title{Neurofibromatosis type 1 backcross data}
\format{An object of class \code{cross}.  See \code{\link[qtl:read.cross]{qtl::read.cross()}}
for details.}
\usage{
nf1
}
\description{
Data from a backcross experiment on neurofibromatosis type I.  All
individuals carry the \emph{NPcis} mutation, received either from their
mother or from their father.
}
\details{
Backcrosses (C57BL/6J x A/J) x C57BL/6J and C57BL/6J x (A/J x C57BL/6J) with
a total of 254 individuals.  Individuals received the \emph{NPcis} mutation
from either their mother or their father (indicated by the phenotype
\code{from.mom}.  The major phenotype, \code{affected} indicates whether the
mice were affected (1) or unaffected (0) with neurofibromatosis type 1.
}
\examples{
data(nf1)
library(qtl)
plot(nf1)

}
\references{
Reilly, K. M., Broman, K. W., Bronson, R. T., Tsang, S., Loisel,
D. A., Christy, E. S., Sun, Z., Diehl, J., Munroe, D. J. and Tuskan, R. G.
(2006) An imprinted locus epistatically influences \emph{Nstr1} and
\emph{Nstr2} to control resistance to nerve sheath tumors in a
neurofibromatosis type 1 mouse model.  \emph{Cancer Research} \strong{66},
62--68.
#' @source Karlyne Reilly, Mouse Cancer Genetics Program, National Cancer
Institute at Frederick, \email{kreilly@ncifcrf.gov}
}
\seealso{
\code{link{gutlength}} \code{link{iron}}, \code{link{myocard}},
\code{link{ovar}}, \code{link{trout}}
}
\keyword{datasets}
