% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_raw_summaries.R
\name{calc_raw_het}
\alias{calc_raw_het}
\title{Calculate estimated heterozygosity from raw SNP genotypes}
\usage{
calc_raw_het(cross, by = c("individual", "marker"))
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{by}{Indicates whether to summarize by founder strain (\code{"individual"}) or by marker.}
}
\value{
A vector of heterozygosities, one for each individual or marker.
}
\description{
Calculate estimated heterozygosity for each individual from raw SNP genotypes
}
\examples{
\dontrun{
# load example data and calculate genotype probabilities
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/main/DOex/DOex.zip")
DOex <- read_cross2(file)
DOex_het <- calc_raw_het(DOex)
}
}
\seealso{
\code{\link[=recode_snps]{recode_snps()}}, \code{\link[=calc_raw_maf]{calc_raw_maf()}}, \code{\link[=calc_raw_founder_maf]{calc_raw_founder_maf()}}, \code{\link[=calc_raw_geno_freq]{calc_raw_geno_freq()}}
}
\keyword{utilities}
