% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind_calc_genoprob.R
\name{cbind.calc_genoprob}
\alias{cbind.calc_genoprob}
\title{Join genotype probabilities for different chromosomes}
\usage{
\method{cbind}{calc_genoprob}(...)
}
\arguments{
\item{...}{Genotype probability objects as produced by
\code{\link[=calc_genoprob]{calc_genoprob()}}. Must have the same set of individuals.}
}
\value{
An object of class \code{"calc_genoprob"}, like the input; see \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\description{
Join multiple genotype probability objects, as produced by
\code{\link[=calc_genoprob]{calc_genoprob()}}, for the same set of individuals but different
chromosomes.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probsA <- calc_genoprob(grav2[1:5,1:2], map, error_prob=0.002)
probsB <- calc_genoprob(grav2[1:5,3:4], map, error_prob=0.002)
probs <- cbind(probsA, probsB)

}
\seealso{
\code{\link[=rbind.calc_genoprob]{rbind.calc_genoprob()}}
}
