% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind_calc_genoprob.R
\name{rbind.calc_genoprob}
\alias{rbind.calc_genoprob}
\title{Join genotype probabilities for different individuals}
\usage{
\method{rbind}{calc_genoprob}(...)
}
\arguments{
\item{...}{Genotype probability objects as produced by
\code{\link[=calc_genoprob]{calc_genoprob()}}. Must have the same set of markers and
genotypes.}
}
\value{
An object of class \code{"calc_genoprob"}, like the input; see \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\description{
Join multiple genotype probability objects, as produced by
\code{\link[=calc_genoprob]{calc_genoprob()}}, for the same set of markers and genotypes but for
different individuals.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map <- insert_pseudomarkers(grav2$gmap, step=1)
probsA <- calc_genoprob(grav2[1:5,], map, error_prob=0.002)
probsB <- calc_genoprob(grav2[6:12,], map, error_prob=0.002)
probs <- rbind(probsA, probsB)

}
\seealso{
\code{\link[=cbind.calc_genoprob]{cbind.calc_genoprob()}}
}
