% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_colpairs.R
\name{chisq_colpairs}
\alias{chisq_colpairs}
\title{Chi-square test on all pairs of columns}
\usage{
chisq_colpairs(x)
}
\arguments{
\item{x}{A matrix of positive integers. \code{NA}s and values <= 0 are treated as missing.}
}
\value{
A matrix of size p x p, where p is the number of columns in
the input matrix \code{x}, containing the chi-square test
statistics for independence, applied to pairs of columns of
\code{x}. The diagonal of the result will be all \code{NA}s.
}
\description{
Perform a chi-square test for independence for all pairs of columns of a matrix.
}
\examples{
z <- matrix(sample(1:2, 500, replace=TRUE), ncol=5)
chisq_colpairs(z)
}
\keyword{htest}
