% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_obj.R
\name{write_obj}
\alias{write_obj}
\title{Write an R object as a file}
\usage{
write_obj(obj, file = NULL, target_dir = NULL, ...)
}
\arguments{
\item{obj}{The R object to be written.}

\item{file}{The name of the file to be written. If not specified, the
label of the code block will be used.}

\item{target_dir}{The directory where the file will be written. If not
specified, the current working directory will be used.}

\item{...}{Additional arguments to be passed to \code{dput}.}
}
\value{
The path of the written file.
}
\description{
This function is a wrapper around \code{dput} that allows you
to write an R object as part of a knitr document as an output for
later use. It is designed to be used in a code block. The file name, if
not specified, will be the label of the code block. Use the standard
\code{dget} function to read the file back into an R session.
}
\examples{
\dontrun{
obj_dir <- file.path(tempdir(), "obj")

# Write a data frame as a file
write_obj(
 obj = mtcars,
 file = "mtcars_data",
 target_dir = obj_dir)

# Read the file back into an R session
my_mtcars <- dget(file.path(obj_dir, "mtcars_data"))

unlink(obj_dir)
}
}
\keyword{publishing}
