% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.R
\name{bounds}
\alias{bounds}
\title{bounds}
\usage{
bounds(formla, xformla = NULL, t, tmin1, tname, data, idname,
  probs = seq(0.05, 0.95, 0.05))
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary), d should be equal to one
in all time periods for individuals that are eventually treated}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{t}{The 3rd time period in the sample.  Treated individuals should
be treated in this time period and untreated individuals should not be
treated.  The code attempts to enforce this condition, but it is good
try to handle this outside the panel.qtet method.}

\item{tmin1}{The 2nd time period in the sample.  This should be a
pre-treatment period for all individuals in the sample.}

\item{tname}{The name of the column containing the time periods}

\item{data}{A data.frame containing all the variables used}

\item{idname}{The individual (cross-sectional unit) id name}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}
}
\value{
A \code{BoundsObj} object
}
\description{
\code{bounds} estimates bounds for the Quantile Treatment
 Effect on the
 Treated (QTET) using the method of Fan and Yu (2012).
}
\examples{
## load the data
data(lalonde)

## Run the bounds method with no covariates
b1 <- bounds(re ~ treat, t=1978, tmin1=1975, data=lalonde.psid.panel,
  idname="id", tname="year")
summary(b1)

}
\references{
Fan, Yanqin and Zhengfei Yu.  ``Partial Identification of Distributional
 and Quantile Treatment Effects in Difference-in-Differences Models.''
 Economics Letters 115.3, pp.511-515, 2012.
}
