% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qte.R
\name{panel.qtet}
\alias{panel.qtet}
\title{panel.qtet}
\usage{
panel.qtet(formla, t, tmin1, tmin2, tname, x = NULL, data,
  dropalwaystreated = TRUE, idname, probs = seq(0.05, 0.95, 0.05),
  iters = 100, alp = 0.05, method = "logit", plot = FALSE, se = TRUE,
  seedvec = NULL)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{t}{The 3rd time period in the sample (this is the name of the column)}

\item{tmin1}{The 2nd time period in the sample (this is the name of the
column)}

\item{tmin2}{The 1st time period in the sample (this is the name of the
column)}

\item{tname}{The name of the column containing the time periods}

\item{x}{A vector of covariates (the name of the columns)}

\item{data}{The name of the data.frame that contains the data}

\item{dropalwaystreated}{How to handle always treated observations
in panel data case (not currently used)}

\item{idname}{The individual (cross-sectional unit) id name}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{method}{The method for estimating the propensity score when covariates
are included}

\item{plot}{Boolean whether or not the estimated QTET should be plotted}

\item{se}{Boolean whether or not to compute standard errors}

\item{seedvec}{Optional value to set random seed; can possibly be used
 in conjunction with bootstrapping standard errors.}
}
\value{
\code{QTE} object
}
\description{
\code{panel.qtet} computes the Quantile Treatment Effect
on the Treated (QTET) using the method of Callaway and Li (2015).  This
method should be used when the researcher wants to invoke a Difference
in Differences assumption to identify the QTET.  Relative to the other
Difference in Differences methods available in the \code{qte} package,
this method's assumptions are more intuitively similar to the identifying
assumptions used in identifying the Average Treatment Effect on the Treated
(ATT).

Additionally, this method can accommodate covariates in a more
flexible way than the other Difference in Differences methods available.
In order to accommodate covariates, the user should specify a vector \code{x}
of covariate names.  The user also may specify a method for estimating
the propensity score.  The default is logit.

\code{panel.qtet} can only be used in some situations, however.  The
method requires three periods of panel data where individuals
are not treated until the last period.  The data should be formatted
as a panel; the names of columns containing time periods and ids
for each cross sectional unit need to be passed to the method.
}
\examples{
##load the data
data(lalonde)

## Run the panel.qtet method on the experimental data with no covariates
pq1 <- panel.qtet(re ~ treat, t=1978, tmin1=1975, tmin2=1974, tname="year",
 x=NULL, data=lalonde.exp.panel, idname="id", se=FALSE,
 probs=seq(0.05, 0.95, 0.05))
summary(pq1)

## Run the panel.qtet method on the observational data with no covariates
pq2 <- panel.qtet(re ~ treat, t=1978, tmin1=1975, tmin2=1974, tname="year",
 x=NULL, data=lalonde.psid.panel, idname="id", se=FALSE,
 probs=seq(0.05, 0.95, 0.05))
summary(pq2)

## Run the panel.qtet method on the observational data conditioning on
## age, education, black, hispanic, married, and nodegree.
## The propensity score will be estimated using the default logit method.
pq3 <- panel.qtet(re ~ treat, t=1978, tmin1=1975, tmin2=1974, tname="year",
 x=c("age","education","black","hispanic","married","nodegree"),
 data=lalonde.psid.panel, idname="id", se=FALSE,
 probs=seq(0.05, 0.95, 0.05))
summary(pq3)
}
\references{
Callaway, Brantly and Tong Li.  ``Quantile Treatment Effects in Difference
 in Differences Models with Panel Data.'' Working Paper, 2015.
}

