% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qspray.R
\name{integratePolynomialOnSimplex}
\alias{integratePolynomialOnSimplex}
\title{Integral of a multivariate polynomial over a simplex}
\usage{
integratePolynomialOnSimplex(P, S)
}
\arguments{
\item{P}{a \code{qspray} object}

\item{S}{the simplex, a \code{(n+1)xn} matrix such that each entry of the
matrix \code{as.character(S)} is a quoted integer or a quoted fraction}
}
\value{
A \code{bigq} number, the exact value of the integral.
}
\description{
Returns the exact value of the integral of a multivariate 
  polynomial with rational coefficients over a simplex whose vertices have 
  rational coordinates.
}
\examples{
library(qspray)
x <- qlone(1); y <- qlone(2)
P <- x/2 + x*y
S <- rbind(c("0", "0"), c("1", "0"), c("1", "1")) # a triangle
integratePolynomialOnSimplex(P, S)
}
