% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs_to_rds.R
\name{qs_to_rds}
\alias{qs_to_rds}
\title{qs2 to RDS format}
\usage{
qs_to_rds(input_file, output_file, compress_level = 6)
}
\arguments{
\item{input_file}{The \code{qs2} file to convert.}

\item{output_file}{The \code{RDS} file to write.}

\item{compress_level}{The gzip compression level to use when writing the RDS file (a value between 0 and 9).}
}
\value{
No value is returned. The converted file is written to disk.
}
\description{
Converts a file saved in the \code{qs2} format to the \code{RDS} format.
}
\examples{
qs_tmp <- tempfile(fileext = ".qs2")
rds_tmp <- tempfile(fileext = ".RDS")

x <- runif(1e6)
qs_save(x, qs_tmp)
qs_to_rds(input_file = qs_tmp, output_file = rds_tmp)
x2 <- readRDS(rds_tmp)
stopifnot(identical(x, x2))

}
