% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{qd_read}
\alias{qd_read}
\title{qd_read}
\usage{
qd_read(file, use_alt_rep = FALSE, validate_checksum=FALSE, nthreads = 1L)
}
\arguments{
\item{file}{The file name/path.}

\item{use_alt_rep}{Use ALTREP when reading in string data (default \code{FALSE}).}

\item{validate_checksum}{Whether to validate the stored checksum in the file (default \code{FALSE}). This can be used to test for file corruption but has a performance penality.}

\item{nthreads}{The number of threads to use when reading data (default: \code{1}).}
}
\value{
The object stored in \code{file}.
}
\description{
Reads an object that was saved to disk in the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
        num = rnorm(1e3),
        char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
myfile <- tempfile()
qd_save(x, myfile)
x2 <- qd_read(myfile)
identical(x, x2) # returns true

# qdata support multithreading
qd_save(x, myfile, nthreads=1)
x2 <- qd_read(myfile, nthreads=1)
identical(x, x2) # returns true
}
