% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascii_encoding.R
\name{base91_encode}
\alias{base91_encode}
\title{basE91 Encoding}
\usage{
base91_encode(rawdata, quote_character = "\\"")
}
\arguments{
\item{rawdata}{A raw vector.}

\item{quote_character}{The character to use in the encoding, replacing the double quote character. Must be either a single quote (\code{"'"}), a double quote
(\verb{"\\""}) or a dash (\code{"-"}).}
}
\value{
A string representation of the raw vector.
}
\description{
Encodes binary data (a raw vector) as ASCII text using \href{https://base91.sourceforge.net/}{basE91 encoding format}.
}
\details{
basE91 (capital E for stylization) is a binary to ASCII encoding format created by Joachim Henke in 2005.
The overhead (extra bytes used relative to binary) is 22.97\% on average. In comparison, base 64 encoding has an overhead of 33.33\%.
The original encoding uses a dictionary of 91 out of 94 printable ASCII characters excluding \code{-} (dash), \verb{\\} (backslash) and \verb{'} (single quote).
The original encoding does include double quote characters, which are less than ideal for strings in R. Therefore,
you can use the \code{quote_character} parameter to substitute dash or single quote.
}
\references{
https://base91.sourceforge.net/
}
