% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qMap.R
\name{qMap}
\alias{qMap}
\title{qMap}
\usage{
qMap(x)
}
\arguments{
\item{x}{(character or numeric) A vector.}
}
\value{
(numeric or character) A vector of indices, Q-words, or NA of the
  same length as the input.
}
\description{
\code{qMap} maps numbers to Q-words, or Q-words to their index in (0, 1023).
}
\section{Description}{
 \code{qMap} accepts strings that are matched to Q-word
  indices or NA, or numbers that are matched to Q-words or NA. The returned
  vector has the same length as the input. Numbers that are not in (0, 1023)
  return NA. Strings that are not a Q-word return NA. \code{qMap(0)} is
  "aims", \code{qMap(1023)} is "zone". Note: the first Q-word has index 0,
  since it represents the bit-pattern "0000000000".
}

\section{Q-Words}{
 A table of 1,024 four-letter words is encoded in this
  function. Four-letter English words were chosen and manually refined to
  yield short, unique labels that:
  \itemize{
     \item are monosyllabic,
     \item are easy to spell and pronounce,
     \item are individually not offensive,
     \item are unlikely to be offensive in random combination,
     \item are in common use,
     \item avoid homophones and consonant clusters,
     \item do not contain jargon, intentional misspellings, acronyms
           or overly specialized technical or sports terms. }
  The table is alphabetically sorted.
}

\examples{
# qMap a number
qMap(313)                                    # "gift"
# qMap four words, three can be matched.
qMap(c("three", "free", "cold", "beer"))     # NA 287  125  34
# return the entire QQ table
x <- qMap(0:1023)

}
\author{
(c) 2019 \href{https://orcid.org/0000-0002-1134-6758}{Boris Steipe},
licensed under MIT (see file \code{LICENSE} in this package).
}
