% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_helpers.R
\name{running_number}
\alias{running_number}
\title{Compute Running Numbers}
\usage{
running_number(data_frame, var_name = "run_nr", by = NULL)
}
\arguments{
\item{data_frame}{The data frame in which to compute the running number.}

\item{var_name}{The variable name of the running number.}

\item{by}{By group in which to compute the running number per expression.}
}
\value{
Returns the data frame with a new variable containing a running number.
}
\description{
Compute running numbers in a data frame. Without specifying a by variable
results in the row number. With by variable computes the running number within
each group of expressions.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Get row numbers
my_data <- my_data |> running_number()
my_data <- my_data |> running_number("row_number")

# Running number per variable expression
my_data <- my_data |> running_number(by = year)

}
