% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmix.R
\name{qmix}
\alias{qmix}
\title{Fitting finite quantile mixture models}
\usage{
qmix(formula, data, nmix = 3, design = "fixed", q = NULL,
  nsim = 1000, burnin = NULL, thin = 1, CIsize = 0.95,
  nchain = 1, seeds = 12345, offset = 1e-20, inverse_distr = FALSE)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be
coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{A data frame containing the variables in the model.}

\item{nmix}{The number of mixture components.}

\item{design}{Quantile specification. Options include "fixed" and "random". The default choice is "fixed" which requires quantile inputs from the user.}

\item{q}{The quantile value.}

\item{nsim}{The number of iterations.}

\item{burnin}{The number of burnin iterations.}

\item{thin}{Thinning parameter.}

\item{CIsize}{The size of posterior confidence interval.}

\item{nchain}{The number of parallel chains.}

\item{seeds}{Random seeds to replicate the results.}

\item{offset}{Offset values to enhance sampling stability. The default value is 1e-20.}

\item{inverse_distr}{If FALSE, the ALD will not be reversed. The default is FALSE.}
}
\value{
A \code{qmix} object. An object of class \code{qmix} contains the following elements

  \describe{

  \item{\code{Call}}{The matched call.}
  \item{\code{formula}}{Symbolic representation of the model.}
  \item{\code{nmix}}{Number of mixture components. If unspecified in the fixed-quantile specification, the value equals the number of quantiles specified. Otherwise, an error will be generated for the missing value.}
  \item{\code{design}}{Options include "fixed" and "random" for fixed- and random-quantile specification.}
  \item{\code{q}}{Quantiles in the fixed-quantile specification.}
  \item{\code{nsim}}{Number of iterations.}
  \item{\code{Burnin}}{Number of burnin iterations.}
  \item{\code{thin}}{Thinning.}
  \item{\code{seeds}}{Random seeds for reproducibility. The default is 12345.}
  \item{\code{CIsize}}{Size of the posterior confidence interval.}
  \item{\code{inverse_distr}}{Indicating whether ALD should be inversed.}
  \item{\code{offset}}{Offset to enhance stability in estimation. The default value is 1e-20.}
  \item{\code{data}}{Data used.}
  \item{\code{x}}{Independent variables.}
  \item{\code{y}}{Dependent variables.}
  \item{\code{xnames}}{Names of the independent variables.}
  \item{\code{stanfit}}{Output from stan.}
  \item{\code{sampledf}}{Posterior samples.}
  \item{\code{summaryout}}{Summary of the posterior samples.}
  \item{\code{npars}}{Number of covariates.}
  \item{\code{ulbs}}{Upper and lower bounds based on the specified confidence interval.}
  \item{\code{means}}{Mean estimates.}
  \item{\code{thetas}}{Estimated proportions of each mixture component.}
  \item{\code{binarylogic}}{Indicating whether the data contain a binary dependent variable.}

}
}
\description{
The main function for running the finite quantile mixture model. The function returns a \code{qmix} object that can be further investigated using standard functions such as \code{plot}, \code{print}, and \code{coef}. The model can be passed using a \code{formula} as in \code{lm()}. Convergence diagnotics can be performed using either \code{print(object, "mcmc")} or \code{plot(object, "mcmc")}.
}
\examples{

# simulate a mixture of 2 ALDs
k <- 2
N <- 50
# true effects: -10 and 10 respectively for two mixture components
beta1 <- -10
beta2 <- 10
set.seed(34324)
x1 <- rnorm(N,0,1)
x2 <- rnorm(N,0,1)
xb1 <- x1*beta1
xb2 <- x2*beta2
y1 <- y2 <- NA
# quantiles at 0.1 and 0.9
p1 <- 0.1
p2 <- 0.9
for (i in 1:N){
    y1[i] <- rald(1,mu = xb1[i],p = p1,sigma = 1)
    y2[i] <- rald(1,mu = xb2[i],p = p2,sigma = 1)
}
y <- c(y1,y2)
x <- c(x1,x2)
dat <- as.data.frame(cbind(y,x))
# Estimate the model using both the fixed- and random-quantile specification
model <- qmix(y ~ x, data = dat, nmix = 2, design = "fixed", q = c(0.1, 0.9))
# Summary the results
coef(model)
print(model)
# check traceplots
plot(model)

}
\references{
Lu, Xiao (2019). Beyond the Average: Conditional Hypothesis Testing with Quantile Mixture. Working Paper.
}
