% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{fitCov}
\alias{fitCov}
\title{Covariance parameter estimation}
\usage{
fitCov(models, Xs, data, controls = list(), cl = NULL,
  verbose = FALSE)
}
\arguments{
\item{models}{object either of class \code{krige}, a list of covariance models or an object of
class \code{covModel} (a single covariance model)}

\item{Xs}{matrix of sample points (design points)}

\item{data}{data frame of simulated sample means of statistics
first column corresponds to the first model in the list `\code{models}` and so forth}

\item{controls}{list of control parameters, see \code{\link[nloptr]{nloptr}}}

\item{cl}{cluster object, \code{NULL} (default), of class "\code{MPIcluster}", "\code{SOCKcluster}", "\code{cluster}"}

\item{verbose}{logical, \code{FALSE} (default) for intermediate output}
}
\value{
An object of class \code{reml} which consists of a list of named lists
 (of elements `\code{model}` and `\code{convergence}`) each storing a fitted covariance model
 together with optimization results from a call to \code{\link[nloptr]{nloptr}} as an attribute
 named `\code{optres}` if \code{verbose=TRUE}. The default method for estimation is \code{\link[nloptr]{mlsl}} which
 uses random starting points and thus produces different results if it is run more than onces. If the results strongly vary,
 then the corresponding REML function might have many local minima which precludes the use of this default algorithm and another
 one, e.g. `\code{NLOPT_GN_DIRECT}` (see \code{\link[nloptr]{nloptr.print.options}}), might lead to better results.
}
\description{
The function estimates the (hyper)parameters of a list of covariance models `\code{models}` by
	  the \emph{Restricted Maximum Likelihood} (REML) estimation method.
}
\details{
The function fits a list of covariance models using the REML method. In order to avoid singularities
 of the so-called trend matrices make sure to use at least the minimum required number of sample points given by
 `\code{Xs}` which depends on trend order, see \code{\link{setCovModel}}. THe use is given an advice if the trend order does
 not match the required number of (initial) design points.
}
\examples{
data(normal)  

# fit 1st statistic and get REML results
fitCov(qsd$covT[1],
       Xs=as.matrix(qsd$qldata[1:2]),
       data=qsd$qldata["mean.T1"],verbose=TRUE)
  
}
\seealso{
\code{\link{setCovModel}}
}
\author{
M. Baaske
}
