% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_simulation.R
\name{gsim}
\alias{gsim}
\title{Genomic simulation}
\usage{
gsim(Glist = NULL, chr = 1, nt = 1, W = NULL, n = 1000, m = 1000, rsids = NULL)
}
\arguments{
\item{Glist}{A list of information about the genotype matrix. Default is `NULL`.}

\item{chr}{The chromosome(s) being used in the simulation. Default is 1.}

\item{nt}{Number of traits. Default is 1.}

\item{W}{Matrix of centered and scaled genotypes. Default is `NULL`.}

\item{n}{Number of individuals. Default is 1000.}

\item{m}{Number of markers. Default is 1000.}

\item{rsids}{A character vector of rsids. Default is `NULL`.}
}
\value{
A list containing:
\itemize{
  \item \code{y}: Phenotypes.
  \item \code{W}: Matrix of centered and scaled genotypes.
  \item \code{e}: Errors.
  \item \code{g}: Genotype effect.
  \item \code{b0}, \code{b1}: Coefficients.
  \item \code{set0}, \code{set1}: Selected markers.
  \item \code{causal}: Causal markers.
}
}
\description{
Simulate Genotype and Phenotype Data
}
\details{
This function simulates genotype and phenotype data based on the `Glist`, which is 
information about the genotype matrix.
}
\examples{
## Plink bed/bim/fam files
bedfiles <- system.file("extdata", paste0("sample_chr",1:2,".bed"), package = "qgg")
bimfiles <- system.file("extdata", paste0("sample_chr",1:2,".bim"), package = "qgg")
famfiles <- system.file("extdata", paste0("sample_chr",1:2,".fam"), package = "qgg")

# Summarize bed/bim/fam files
Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles, famfiles=famfiles)

# Simulate phenotype
sim <- gsim(Glist=Glist, chr=1, nt=1)
head(sim$y)
head(sim$e)
head(sim$causal)

}
\author{
Peter Soerensen
}
