% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{qspec.sqrlw}
\alias{qspec.sqrlw}
\title{Spline-Quantile-Regression-Lag-Window (SQRLW) Estimator of Quantile Spectrum}
\usage{
qspec.sqrlw(
  y,
  tau,
  y.sqdft = NULL,
  M = NULL,
  c0 = 0.02,
  d = 4,
  weighted = FALSE,
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{y.sqdft}{matrix or array of pre-calculated SQDFT (default = \code{NULL}: compute from \code{y} and \code{tau});
if \code{y.sqdft} is supplied, \code{y} and \code{tau} can be left unspecified}

\item{M}{bandwidth parameter of lag window (default = \code{NULL}: quantile periodogram)}

\item{c0}{penalty parameter for SQDFT}

\item{d}{subsampling rate of quantile levels for SQDFT (default = 1)}

\item{weighted}{if \code{TRUE}, SQR penalty function is weighted (default = \code{FALSE})}

\item{n.cores}{number of cores for parallel computing of SQDFT (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing of SQDFT (default = \code{NULL})}
}
\value{
A list with the following elements:
  \item{spec}{matrix or array of quantile spectrum/cross-spectrum}
  \item{lw}{lag-window sequence}
  \item{sqdft}{matrix or array of spline quantile discrete Fourier transform if \code{y.sqdft = NULL}}
}
\description{
This function computes spline-quantile-regression-lag-window (SQRLW) estimate of quantile spectrum/cross-spectrum 
from time series or spline quantile discrete Fourier transform (SQDFT).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qper.sqrlw <- qspec.sqrlw(cbind(y1,y2),tau,M=5,c0=0.02,d=4)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.sqrlw[1,1,sel.f,]))
}
