% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.0.R
\name{sar.gc.test}
\alias{sar.gc.test}
\title{Wald Test and Confidence Band for SAR-Based Granger-Causality Analysis}
\usage{
sar.gc.test(A, A.sim, sel.lag = NULL, sel.tau = NULL)
}
\arguments{
\item{A}{matrix of selected SAR coefficients}

\item{A.sim}{simulated bootstrap samples from \code{sar.gc.bootstrap()}}

\item{sel.lag}{indices of time lags for Wald test (default = \code{NULL}: all lags)}

\item{sel.tau}{indices of quantile levels for Wald test (default = \code{NULL}: all quantiles)}
}
\value{
a list with the following elements:
  \item{test}{list of Wald test result containing \code{wald} and \code{p.value}}
  \item{A.u}{matrix of upper limits of 95\% confidence band of \code{A}}
  \item{A.l}{matrix of lower limits of 95\% confidence band of \code{A}}
}
\description{
This function computes Wald test and confidence band for Granger-causality 
using bootstrap samples generated by \code{sar.gc.bootstrap()} 
based the spline autoregression (SAR) model of quantile series (QSER).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.sar <- qspec.sar(cbind(y1,y2),tau=tau,p=1)
A <- sar.gc.coef(y.sar$fit,index=c(1,2))
A.sim <- sar.gc.bootstrap(y.sar$qser,y.sar$fit,index=c(1,2),nsim=5)
y.gc <- sar.gc.test(A,A.sim)
}
