% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.0.R
\name{qsmooth.qdft}
\alias{qsmooth.qdft}
\title{Quantile Smoothing of Quantile Discrete Fourier Transform}
\usage{
qsmooth.qdft(
  y.qdft,
  method = c("gamm", "sp"),
  spar = "GCV",
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y.qdft}{matrix or array of QDFT from \code{qdft()}}

\item{method}{smoothing method: \code{"gamm"} for \code{mgcv::gamm()} (default), 
\code{"sp"} for \code{stats::smooth.spline()}}

\item{spar}{smoothing parameter in \code{smooth.spline()} if \code{method = "sp"} (default = \code{"GCV"})}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = NULL)}
}
\value{
matrix or array of quantile-smoothed QDFT
}
\description{
This function computes quantile-smoothed version of quantile discrete Fourier transform (QDFT).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qdft <- qdft(cbind(y1,y2),tau)
y.qdft <- qsmooth.qdft(y.qdft,method="sp",spar=0.9)
y.qacf <- qdft2qacf(y.qdft)
y.qper.qslw <- qspec.lw(y.qacf,M=5)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.qslw[1,1,sel.f,]))
}
