% Generated by roxygen2 (4.0.1): do not edit by hand
\name{Animate.formality}
\alias{Animate.formality}
\title{Animate Formality}
\usage{
\method{Animate}{formality}(x, contextual = "yellow", formal = "red",
  edge.constant, wc.time = TRUE, time.constant = 2, title = NULL,
  digits = 3, current.color = "black", current.speaker.color = NULL,
  non.speaker.color = NA, missing.color = "purple",
  all.color.line = "red", plus.300.color = "grey40",
  under.300.color = "grey88", as.network = TRUE, ...)
}
\arguments{
\item{x}{A \code{\link[qdap]{formality}} object.}

\item{contextual}{The color to use for 0\% formality (purely contextual).}

\item{formal}{The color to use for 100\% formality (purely formal).}

\item{edge.constant}{A constant to multiple edge width by.}

\item{wc.time}{logical.  If \code{TRUE} weights duration of frame by word
count.}

\item{time.constant}{A constant to divide the maximum word count by.  Time
is calculated by `round(exp(WORD COUNT/(max(WORD COUNT)/time.constant)))`.
Therefore a larger constant will make the difference between the large and
small word counts greater.}

\item{title}{The title to apply to the animated image(s).}

\item{digits}{The number of digits to use in the current turn of talk
formality.}

\item{current.color}{The color to use for the current turn of talk formality.}

\item{current.speaker.color}{The color for the current speaker.}

\item{non.speaker.color}{The color for the speakers not currently speaking.}

\item{missing.color}{The color to use in a network plot for edges
corresponding to missing text data.  Use \code{\link[stats]{na.omit}} before
hand to remove the missing values all together.}

\item{all.color.line}{The color to use for the total discourse formality
color line if \code{network = FALSE}.}

\item{plus.300.color}{The bar color to use for grouping variables exceeding
299 words per Heylighen & Dewaele's (2002) minimum word recommendations.}

\item{under.300.color}{The bar color to use for grouping variables less
than 300 words per Heylighen & Dewaele's (2002) minimum word recommendations.}

\item{as.network}{logical.  If \code{TRUE} the animation is a network plot.
If \code{FALSE} the animation is a hybrid dot plot.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{discourse_map}}.}
}
\description{
\code{Animate.formality} - Animate a \code{\link[qdap]{formality}} object.
}
\details{
formality Method for Animate
}
\note{
The width of edges is based on words counts on that edge until that
moment divided by total number of words used until that moment.  Thicker
edges tend to thin as time passes.  The actual duration the current edge
stays as the \code{current.color} is based on word counts for that particular
flow of dialogue divided by total dialogue (words) used.  The edge label is
the current formality for that turn of talk (an aggregation of the sub
sentences of the current turn of talk).  The coloring of the current edge
formality is produced at th sentence level, therefor a label may indicate a
positive current turn of talk, while the coloring may indicate a negative
sentences.  Coloring is based on percentage of formal parts of speech (i.e.,
noun, adjective, preposition, article).
}

