% Generated by roxygen2 (4.0.0): do not edit by hand
\name{blank2NA}
\alias{blank2NA}
\title{Replace Blanks in a dataframe}
\usage{
blank2NA(dataframe, missing = NA)
}
\arguments{
\item{dataframe}{A dataframe with blank (empty) cells.}

\item{missing}{Value to replace empty cells with.}
}
\value{
Returns a data frame with blank spaces replaced.
}
\description{
Replaces blank (empty) cells in a dataframe.  Generally, for internal use.
}
\examples{
\dontrun{
set.seed(15)
dat <- data.frame(matrix(sample(c(month.abb[1:4], ""), 50, TRUE),
    10, byrow = TRUE), stringsAsFactors = FALSE)

dat
blank2NA(dat)
}
}
\seealso{
\code{\link[qdap]{rm_row}}
}

