% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_index.R
\name{pystr_index}
\alias{pystr_index}
\title{Find the lowest index of a substring.}
\usage{
pystr_index(str, sub, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A character vector.}

\item{sub}{A character vector.}

\item{start}{A numeric vector.}

\item{end}{A numeric vector.}
}
\value{
A numeric vector.
}
\description{
Like \code{\link{pystr_find}} but raises an error if \code{sub} is not found.
}
\examples{
pystr_index("abcxyzabc", "abc")
pystr_index("abcxyzabc", "abc", 4)
\dontrun{
pystr_index("abcxyzabc", "123")
}
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.index}
}
\seealso{
\code{\link{pystr_rindex}}
}

