% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GrantQualification.R
\name{GrantQualification}
\alias{GrantQualification}
\alias{GrantQualifications}
\alias{grantqual}
\alias{AcceptQualificationRequest}
\alias{acceptrequest}
\alias{RejectQualification}
\alias{RejectQualifications}
\alias{rejectrequest}
\title{Grant/Accept or Reject a Qualification Request}
\usage{
GrantQualification(qual.requests, values, reason = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{qual.requests}{A character string containing a QualificationRequestId (for example, returned by \code{\link{GetQualificationRequests}}), or a vector of QualificationRequestIds.}

\item{values}{A character string containing the value of the Qualification
to be assigned to the worker, or a vector of values of length equal to the
number of QualificationRequests.}

\item{reason}{An optional character string, or vector of character strings
of length equal to length of the \code{qual.requests} parameter, supplying
each worker with a reason for rejecting their request for the Qualification.
Workers will see this message. Maximum of 1024 characters.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationRequestId, reason for
rejection (if applicable; only for \code{RejectQualification}), and whether
each request was valid.
}
\description{
Gran/accept or reject a worker's request for a Qualification.
}
\details{
Qualifications are publicly visible to workers on the MTurk website and
workers can request Qualifications (e.g., when a HIT requires a
QualificationType that they have not been assigned). QualificationRequests
can be retrieved via \code{\link{GetQualificationRequests}}.
\code{GrantQualification} grants the specified qualification requests.
Requests can be rejected with \code{\link{RejectQualifications}}.

Note that granting a qualification may have the consequence of modifying a
worker's existing qualification score. For example, if a worker already has
a score of 100 on a given QualificationType and then requests the same
QualificationType, a \code{GrantQualification} action might increase or
decrease that worker's qualification score.

Similarly, rejecting a qualification is not the same as revoking a worker's
Qualification. For example, if a worker already has a score of 100 on a
given QualificationType and then requests the same QualificationType, a
\code{RejectQualification} leaves the worker's existing Qualification in
place. Use \code{\link{RevokeQualification}} to entirely remove a worker's
Qualification.

\code{GrantQualifications()}, \code{grantqual()}, \code{AcceptQualificationRequest()}
and \code{acceptrequest()} are aliases; \code{RejectQualifications()} and
\code{rejectrequest()} are aliases.
}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html}{API Reference: AcceptQualificationRequest}
}
\seealso{
\code{\link{GetQualificationRequests}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
