% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateQualificationRequirement.R
\name{GenerateQualificationRequirement}
\alias{GenerateQualificationRequirement}
\title{Generate QualificationRequirement}
\usage{
GenerateQualificationRequirement(quals)
}
\arguments{
\item{quals}{A list of lists of Qualification parameters. Each list contains:
QualificationTypeId (string, REQUIRED), Comparator (string, REQUIRED),
LocaleValues (vector of integers), LocaleValues (list containing Country
= string, and optionally Subdivision = string), RequiredToPreview (logical),
ActionsGuarded (string). See example below.}
}
\value{
Returns a special reticulated 'tuple' object
}
\description{
Generate a QualificationRequirement data structure for use with
\code{\link{CreateHIT}} or \code{\link{RegisterHITType}}.
}
\details{
A convenience function to translate the details of a
QualificationRequirement into the necessary structure for use in the
\code{qual.req} parameter of \code{\link{CreateHIT}} or
\code{\link{RegisterHITType}}. The function accepts a list of lists of
Qualification parameters.
}
\examples{

\dontrun{
quals.list <- list(
    list(QualificationTypeId = "2F1KVCNHMVHV8E9PBUB2A4J79LU20F",
         Comparator = "Exists",
         IntegerValues = 1,
         RequiredToPreview = TRUE
    ),
    list(QualificationTypeId = "00000000000000000071",
         Comparator = "EqualTo",
         LocaleValues = list(Country = "US"),
         RequiredToPreview = TRUE
    )
)
GenerateQualificationRequirement(quals.list) -> qual.req
}


}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_QualificationRequirementDataStructureArticle.html}{API Reference}
}
\seealso{
\code{\link{CreateHIT}}

\code{\link{RegisterHITType}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
