#################################################################
# 
# File:         as.array.px.R
# Purpose:      Converts a px object to an array
#
# Created:      20110801
# Authors:      fvf
#
# Modifications: opl 
#
#################################################################

as.array.px <- function(x, use.codes = FALSE,... ){
  
   names.vals      <- c( rev(x$HEADING$value), rev( x$STUB$value ) )
    
   there.codes <- ! ( sapply(x$CODES[names.vals],is.null) )
    
   if ( is.logical( use.codes ) & use.codes == FALSE ) {
        there.codes <- rep(FALSE,length(there.codes))  # don't use codes
   } else if  ( is.character( use.codes ) ) {
                 with.codes <- ! is.na(match(names.vals,use.codes))
                 there.codes <-  with.codes & there.codes   
     } 
    
   x$VALUES[names.vals][there.codes] <- x$CODES[names.vals][there.codes] 

   result <- array( x$DATA[[1]],
                    unlist( lapply( x$VALUES[names.vals] ,length ) ),
                    dimnames = x$VALUES[names.vals] )

   names( dimnames(result) ) <- names.vals

   return(result)
  
}


