% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfromd.R
\name{tfromd}
\alias{tfromd}
\title{Compute power for a t test using d statistic
Takes d, sample size range, type of test, and tails.}
\usage{
tfromd(d, nlow, nhigh, alpha = 0.05, test = "I", tails = 2, by = 2)
}
\arguments{
\item{d}{standardize mean difference (Cohen's d)}

\item{nlow}{Starting total sample size}

\item{nhigh}{Ending total sample size}

\item{alpha}{Type I error (default is .05)}

\item{test}{"I" for independent, "P" for paired}

\item{tails}{one or two-tailed tests (default is 2)}

\item{by}{Incremental increase in sample size from low to high}
}
\value{
Power for the t-test from d statistic
}
\description{
Compute power for a t test using d statistic
Takes d, sample size range, type of test, and tails.
}
\examples{
tfromd(d=.2,nlow=10,nhigh=200,by=10, test="P")
tfromd(d=.2,nlow=10,nhigh=200,by=10, test="I")
}
