% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chi2x3.R
\name{Chi2X3}
\alias{Chi2X3}
\title{Compute power for an Chi Square 2x3
Takes proportions for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
Chi2X3(r1c1, r1c2, r1c3, r2c1, r2c2, r2c3, n, alpha = 0.05)
}
\arguments{
\item{r1c1}{Proportion of overall scores in Row 1, Column 1}

\item{r1c2}{Proportion of overall scores in Row 1, Column 2}

\item{r1c3}{Proportion of overall scores in Row 1, Column 3}

\item{r2c1}{Proportion of overall scores in Row 2, Column 1}

\item{r2c2}{Proportion of overall scores in Row 2, Column 2}

\item{r2c3}{Proportion of overall scores in Row 2, Column 3}

\item{n}{Total sample size}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for 2x3 Chi Square
}
\description{
Compute power for an Chi Square 2x3
Takes proportions for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
Chi2X3(r1c1=.25,r1c2=.25,r1c3=.10, r2c1=.10,r2c2=.25,r2c3=.05,n=200)
}
