# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Change Points of a \code{numeric} vector
#'
#' Finds changes points (i.e. corners) in the \code{numeric} vector.
#'
#' The end points of the vector will be always included in the results. 
#'
#' @return The vector of index of change points.
#' @param x \code{numeric} vector.
#' @export
#' @examples
#' x <- rwiener(100)
#' cid <- ChangePoints(x)
#' plot(x, type="l")
#' points(time(x)[cid], x[cid], cex=0.5, col=2, pch=19)
ChangePoints <- function(x) {
    .Call('pvar_ChangePoints_fromR', PACKAGE = 'pvar', x)
}

#' p-variation calculation (in C++)
#' 
#' An internal function(written in C++) that calculates p-variation. 
#' 
#' This is a waking horse of this packages, nonetheless, users should 
#' not call this function directly (rather use \code{\link{pvar}}).
#' 
#' @return An object of the class \code{pvar}.
#' @keywords internal
#' @inheritParams  pvar
#' @export
pvarC <- function(x, p, LSI = 3L) {
    .Call('pvar_pvarC', PACKAGE = 'pvar', x, p, LSI)
}

#' Addition of p-variation (in C++)
#' 
#' An internal function(written in C++) that merges two objects of pvar and effectively recalculates the p-variation of joined sample.
#' 
#' This is an internal function, therefore, users should 
#' not call this function directly (rather use \code{\link{AddPvar}} or \code{pv1 + pv2}).
#' 
#' @return An object of the class \code{pvar}.
#' @keywords internal
#' @inheritParams  AddPvar
#' @export
AddPvarC <- function(PV1, PV2, AddIfPossible = TRUE) {
    .Call('pvar_AddPvar', PACKAGE = 'pvar', PV1, PV2, AddIfPossible)
}

CheckSmallIntervals <- function(x, p, dn) {
    .Call('pvar_test_CheckSmallIntervals', PACKAGE = 'pvar', x, p, dn)
}

prepare_prt <- function(x, p) {
    .Call('pvar_test_prepare_prt', PACKAGE = 'pvar', x, p)
}

