% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvlrt-object-S3-methods.R
\name{print.pvlrt}
\alias{print.pvlrt}
\title{Print method for pvlrt objects}
\usage{
\method{print}{pvlrt}(
  x,
  significance_level = 0.05,
  topn = 12,
  digits = 2,
  show_test_summary = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{pvlrt} object; an output of function \code{pvlrt}().}

\item{significance_level}{numeric. Level of significance.}

\item{topn}{number of top (with respect to likelihood ratio statistic value)
pairs to show at the given significance level.}

\item{digits}{number of digits to show after the decimal place.}

\item{show_test_summary}{logical. Should a brief summary showing the top few
test results be displayed? defaults to FALSE.}

\item{...}{other input parameters. Currently unused.}
}
\value{
Invisibly returns the input \code{pvlrt} object.
}
\description{
Print method for pvlrt objects
}
\examples{

# 500 bootstrap iterations (nsim) in the example below
# are for quick demonstration only --
# we recommended setting nsim to 10000 (default) or bigger

test1 <- pvlrt(statin46, nsim = 500)
print(test1)

}
\seealso{
\link{pvlrt}
}
