% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvlrt-postprocessing-utils.R
\name{extract_lrstat_matrix}
\alias{extract_lrstat_matrix}
\alias{extract_p_value_matrix}
\alias{extract_zi_probability}
\alias{extract_n_matrix}
\alias{extract_significant_pairs}
\alias{extract_run_time}
\title{Extract various summary measures from a pvlrt object}
\usage{
extract_lrstat_matrix(object, ...)

extract_p_value_matrix(object, ...)

extract_zi_probability(object, ...)

extract_n_matrix(object, ...)

extract_significant_pairs(object, significance_level = 0.05, ...)

extract_run_time(object, ...)
}
\arguments{
\item{object}{a \code{pvlrt} object, which is the output of the function
\link{pvlrt} or one of its wrappers such as \link{lrt_zi_poisson},
\link{lrt_poisson} and \code{lrt_vanilla_poisson}.}

\item{...}{other input parameters. Currently unused.}

\item{significance_level}{numeric. Level of significance.}
}
\value{
\itemize{
\item \code{extract_lrstat_matrix} returns the matrix of
the computed log-likelihood ratio test statistics for signals. This produces
a result identical to applying \code{as.matrix}.
\item \code{extract_p_value_matrix} returns the matrix of
computed p-values associated with the likelihood ratio tests.
\item \code{extract_zi_probability} returns a vector of (estimated)
zero-inflation probabilities.
\item \code{extract_n_matrix} returns the original contingency table (matrix)
used.
\item \code{extract_significant_pairs} returns a data.table listing the AE/drug
pairs determined to be significant at the provided significance level. This
is essentially a subset of the data.table obtained through summary.pvlrt()
that satisfies the provided significance threshold.
\item \code{extract_run_time} returns a \link{difftime} object measuring the
total CPU time needed to run the original \link{pvlrt} call.
}
}
\description{
Extract various summary measures from a pvlrt object
}
\examples{

# 500 bootstrap iterations (nsim) in the example below
# are for quick demonstration only --
# we recommended setting nsim to 10000 (default) or bigger

test1 <- pvlrt(statin46, test_zi = TRUE, nsim = 500)
extract_lrstat_matrix(test1)
extract_p_value_matrix(test1)
extract_zi_probability(test1)
extract_n_matrix(test1)
extract_significant_pairs(test1)


}
\seealso{
\link{pvlrt}
}
