% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_main_function.R
\name{tuning_general_gamma}
\alias{tuning_general_gamma}
\title{Select hyperparameter alpha and obtain the optimal general-gamma model based
on AIC and BIC}
\usage{
tuning_general_gamma(
  contin_table,
  alpha_vec = NULL,
  return_all_fit = FALSE,
  return_all_AIC = TRUE,
  return_all_BIC = TRUE
)
}
\arguments{
\item{contin_table}{an IxJ contingency table showing pairwise counts of adverse
events for I AEs (along the rows) and J drugs (along the columns).}

\item{alpha_vec}{vector of hyperparameter alpha values to be selected. Alpha
is hyperparameter in general-gamma model which is numeric and between 0 and 1.
If is NULL, a default set of alpha values (0, 0.1, 0.3, 0.5, 0.7, 0.9) will
be used.}
}
\value{
a list of fitted models with hyperparameter alpha selected by AIC or BIC.
}
\description{
Select hyperparameter alpha and obtain the optimal general-gamma model based
on AIC and BIC
}
\references{
Akaike H. A new look at the statistical model identification. \emph{IEEE Transactions on Automatic Control.}
2003; 19(6):716-23. \cr

Schwarz G. Estimating the dimension of a model. \emph{The Annals of Statistics.}
1978; 1:461-4.
}
\keyword{internal}
