% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pushover.R
\name{pushover}
\alias{pushover}
\alias{pushover_emergency}
\alias{pushover_high}
\alias{pushover_normal}
\alias{pushover_quiet}
\alias{pushover_silent}
\title{Send a message using Pushover}
\usage{
pushover(message, title = NULL, priority = 0, user = get_pushover_user(),
  app = get_pushover_app(), device = NULL, sound = NULL, url = NULL,
  url_title = NULL, retry = 60, expire = 3600, callback = NULL,
  timestamp = NULL)

pushover_silent(message, ...)

pushover_quiet(message, ...)

pushover_normal(message, ...)

pushover_high(message, ...)

pushover_emergency(message, ...)
}
\arguments{
\item{message}{The message to be sent (max. 1024 characters)}

\item{title}{(optional) The message's title}

\item{priority}{Message priority (-2: silent, -1: quiet, 0: normal (default), 1: high, 2: emergency)}

\item{user}{user/group key (see \code{\link{set_pushover_user}})}

\item{app}{application token (see \code{\link{set_pushover_app}})}

\item{device}{(optional) name of the device(s) to send message to. Defaults to all devices.}

\item{sound}{(optional) name of the sound to play (see \url{https://pushover.net/api#sounds})}

\item{url}{(optional) supplementary URL to display with message}

\item{url_title}{(optional) title to show for supplementary URL}

\item{retry}{(optional) how often (in seconds) to repeat emergency priority messages (min: 30 seconds; default: 60 seconds)}

\item{expire}{(optional) how long (in seconds) emergency priority messages will be retried (max: 86400 seconds; default: 3600 seconds)}

\item{callback}{(optional) callback URL to be visited (HTTP POST) once an emergency priority message has been acknowledged (\href{https://pushover.net/api#receipt}{details})}

\item{timestamp}{(optional) a Unix timestamp containing the date and time to display to the user instead of the time at which the message was received}

\item{...}{Additional arguments to pass to \code{pushover()}}
}
\value{
an invisible list containing the following fields:
\itemize{
    \item \code{status}: request status (1 = success)
    \item \code{request}: unique request ID
    \item \code{raw}: the raw \code{\link[httr]{response}} object
    \item \code{receipt}: a receipt ID (only for emergency priority messages)
    \item \code{errors}: a list of error messages (only for unsuccessful requests)
}
}
\description{
\code{pushover} sends a message (push notification) to a user or group.
Messages can be given different priorities, play different sounds, or require
acknowledgments. The \code{pushover_normal}, \code{pushover_silent},
\code{pushover_quiet}, \code{pushover_high}, and \code{pushover_emergency}
functions send messages with those priorities.
}
\examples{
\dontrun{
pushover(message = "Hola Mundo!")
}
}

