% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/every-some-none.R
\name{every}
\alias{every}
\alias{some}
\alias{none}
\title{Do every, some, or none of the elements of a list satisfy a predicate?}
\usage{
every(.x, .p, ...)

some(.x, .p, ...)

none(.x, .p, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.p}{A predicate function to apply on each element of \code{.x}.
\code{some()} returns \code{TRUE} when \code{.p} is \code{TRUE} for at least one
element. \code{every()} returns \code{TRUE} when \code{.p} is \code{TRUE} for all
elements. \code{none()} returns \code{TRUE} when \code{.p} is \code{FALSE} for all
elements.`}

\item{...}{Additional arguments passed on to \code{.p}.}
}
\value{
A logical vector of length 1.
}
\description{
Do every, some, or none of the elements of a list satisfy a predicate?
}
\examples{
y <- list(0:10, 5.5)
y \%>\% every(is.numeric)
y \%>\% every(is.integer)
y \%>\% some(is.integer)
y \%>\% none(is.character)
}
