% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{safely}
\alias{safely}
\alias{quietly}
\alias{possibly}
\alias{auto_browse}
\title{Capture side effects.}
\usage{
safely(.f, otherwise = NULL, quiet = TRUE)

quietly(.f)

possibly(.f, otherwise, quiet = TRUE)

auto_browse(.f)
}
\arguments{
\item{.f}{A function, formula, or atomic vector.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it
is converted to an extractor function. Character vectors index by name
and numeric vectors index by position; use a list to index by position
and name at different levels. Within a list, wrap strings in \code{\link[=get-attr]{get-attr()}}
to extract named attributes. If a component is not present, the value of
\code{.default} will be returned.}

\item{otherwise}{Default value to use when an error occurs.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them
as they occur?}
}
\value{
\code{safely}: wrapped function instead returns a list with
components \code{result} and \code{error}. One value is always \code{NULL}.

\code{quietly}: wrapped function instead returns a list with components
\code{result}, \code{output}, \code{messages} and \code{warnings}.

\code{possibly}: wrapped function uses a default value (\code{otherwise})
whenever an error occurs.
}
\description{
These functions wrap functions so that instead of generating side effects
through printed output, messages, warnings, and errors, they return enhanced
output. They are all adverbs because they modify the action of a verb (a
function).
}
\examples{
safe_log <- safely(log)
safe_log(10)
safe_log("a")

list("a", 10, 100) \%>\%
  map(safe_log) \%>\%
  transpose()

# This is a bit easier to work with if you supply a default value
# of the same type and use the simplify argument to transpose():
safe_log <- safely(log, otherwise = NA_real_)
list("a", 10, 100) \%>\%
  map(safe_log) \%>\%
  transpose() \%>\%
  simplify_all()

# To replace errors with a default value, use possibly().
list("a", 10, 100) \%>\%
  map_dbl(possibly(log, NA_real_))

# For interactive usage, auto_browse() is useful because it automatically
# starts a browser() in the right place.
f <- function(x) {
  y <- 20
  if (x > 5) {
    stop("!")
  } else {
    x
  }
}
if (interactive()) {
  map(1:6, auto_browse(f))
}

# It doesn't make sense to use auto_browse with primitive functions,
# because they are implemented in C so there's no useful environment
# for you to interact with.
}
