% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_dif_rmd.R
\name{var_dif_rmd}
\alias{var_dif_rmd}
\title{var_dif_rmd}
\usage{
var_dif_rmd(sd1i, sd2i, n1i, n2i, r)
}
\arguments{
\item{sd1i}{A vector of standard deviations of the outcomes in group 
1 (see Details)}

\item{sd2i}{A vector of standard deviations of the outcomes in group 
2 (see Details)}

\item{n1i}{An integer specifying the sample size of group 1}

\item{n2i}{An integer specifying the sample size of group 2}

\item{r}{A numerical value specifying the Pearson correlation coefficient 
between participants' scores on the different outcomes}
}
\value{
The \code{var_dif_rmd} function returns a numerical value that is the 
variance of the difference of two raw mean differences given r.
}
\description{
Function for computing the variance of the difference between two raw mean 
differences.
}
\details{
Multiple raw mean differences can be computed in case of two groups 
and multiple outcomes. The function computes the variance of the 
difference of two raw mean differences given a correlation between the outcomes. 
For a derivation of this variance see the supplemental materials of 
van Aert & Wicherts (2020).

The vectors \code{sd1i} and \code{sd2i} can contain a single standard deviation 
or multiple standard deviations if information on more than one outcome 
measure is available.

The variance that is computed with this function can be used to correct for 
outcome reporting bias by including the variance as a moderator in a 
(multivariate) meta-analysis. Please see van Aert & Wicherts (2020) for 
more information.
}
\examples{
### Compute variance for an artificial example
var_dif_rmd(sd1i = c(0.8, 1.2), sd2i = c(0.85, 1.15), n1i = 100, n2i = 95, r = 0.3)

}
\references{
van Aert, R.C.M. & Wicherts, J.M. (2021). Correcting for outcome 
reporting bias in a meta-analysis: A meta-regression approach. Manuscript 
submitted for publication.
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
