% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ideal.R
\name{predict_ideal}
\alias{predict_ideal}
\title{Calculate Probabilities for the IDEAL Model}
\usage{
predict_ideal(vote_info, post_samples)
}
\arguments{
\item{vote_info}{A logical vote matrix (or a rollcall object) in which rows represent members and columns represent issues.
The entries should be FALSE ("No"), TRUE ("Yes"), or NA (missing data).}

\item{post_samples}{Posterior samples obtained from function 'ideal' in 'pscl' package.}
}
\value{
An array of probabilities with three dimensions. The first one represents to members, the second one refers to issues,
and the third one refers to MCMC iterations.
}
\description{
This function computes the probability matrix for the IDEAL Model.
Specifically, it calculates the probabilities of voting "Yea" for each legislator (member),
issue, (and time period) based on the posterior samples of model parameters.
}
\examples{
\donttest{
# Long-running example
data(h116)
h116.c = preprocess_rollcall(h116)
require(pscl)
cl = constrain.legis(h116.c, x = list("CLYBURN" = -1, "SCALISE" = 1),
                     d = 1)
h116.c.ideal = ideal(h116.c, d = 1, priors = cl, startvals = cl,
                     maxiter = 2, thin = 1, burnin = 0,
                     store.item = TRUE)
h116.c.ideal.predprob = predict_ideal(h116.c, h116.c.ideal)
}
}
