% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{qq_plot}
\alias{qq_plot}
\title{Quantile-quantile plots against the standard Normal distribution.}
\usage{
qq_plot(formula, data = NULL, pch = 20, col = 1, aspect = 3/4, ...)
}
\arguments{
\item{formula}{A formula of the form \code{ ~ x} or \code{ ~ x|z} where \code{x} is a numerical variable and \code{z} is a factor.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{pch}{Point character passed to \link{qqmath}.}

\item{col}{Colour passed to \link{qqmath}.}

\item{aspect}{Physical aspect ratio passed to \link{qqmath}.}

\item{...}{Further arguments passed to \link{qqmath}.}
}
\description{
\code{qq_plot} constructs quantile-quantile plots against the standard normal distribution
(also known as quantile-normal plots).
}
\examples{
data(kfm, package = "ISwR")
qq_plot(~ dl.milk, data = kfm, ylab = "Breast-milk intake (dl/day)")
qq_plot(~ dl.milk|sex, data = kfm, ylab = "Breast-milk intake (dl/day)", aspect = 1)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
