% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{hist_norm}
\alias{hist_norm}
\title{Histogram with Normal density curve.}
\usage{
hist_norm(formula, data = NULL, col = "gray70", aspect = 3/4, ...)
}
\arguments{
\item{formula}{A formula of the form \code{ ~ x} where \code{x} is a numerical variable.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{col}{Colour passed to \link{histogram}.}

\item{aspect}{Physical aspect ratio passed to \link{histogram}.}

\item{...}{Further arguments passed to \link{histogram}.}
}
\description{
\code{hist_norm} constructs histograms in lattice and adds corresponding Normal density curve.
}
\examples{
data(birthwt, package = "MASS")
hist_norm(~ bwt, data = birthwt, nint = 15, xlab = "Birth weight (g)")
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
