% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_ls}
\alias{alpha_ls}
\title{Estimating the Shape Parameter by Method of Least Squares}
\usage{
alpha_ls(dat)
}
\arguments{
\item{dat}{vector of observations}
}
\value{
A list of the following form:
\describe{
  \item{shape}{Estimate of the shape parameter of the data}
  \item{scale}{Estimate of the scale parameter of the data (which is taken
  to be the minimum of the data)}
}
}
\description{
This function uses the Method of Least Squares to estimate the \code{shape}
parameter of a given set of data. (Zaher et al. 2014; Nair et al. 2019)
}
\examples{
x <- generate_pareto(10000, 5, 2)
alpha_ls(x)

}
\references{
Zaher HM, El-Sheik AA, El-Magd NATA (2014). "Estimation of Pareto 
Parameters Using a Fuzzy Least-Squares Method and Other Known Techniques 
with a Comparison." British Journal of Mathematics & Computer Science, 
4(14), 2067-2088.

Nair J, Wierman A, Zwart B (2019). "The Fundamentals Of Heavy Tails: 
Properties, Emergence, And Identification."
http://users.cms.caltech.edu/ adamw/heavytails.html.
}
