% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmixed.R
\name{ptmixed}
\alias{ptmixed}
\title{Poisson-Tweedie generalized linear mixed model}
\usage{
ptmixed(
  fixef.formula,
  id,
  offset = NULL,
  data,
  npoints = 5,
  hessian = T,
  trace = T,
  theta.start = NULL,
  reltol = 1e-08,
  maxit = c(10000, 100),
  freq.updates = 200,
  min.var.init = 0.001
)
}
\arguments{
\item{fixef.formula}{A formula for the fixed effects part of the model. 
It should be in the form \code{y ~ x1 + x2}}

\item{id}{A variable to distinguish observations from the same subject.}

\item{offset}{An offset to be added to the linear predictor. Default is \code{NULL}.}

\item{data}{A data frame containing the variables declared in \code{fixef.formula}.}

\item{npoints}{Number of quadrature points employed in the adaptive quadrature. Default is 5.}

\item{hessian}{Logical value. If \code{TRUE}, the hessian matrix is evaluated 
at the MLE to derive the observed Fisher information matrix. Default is \code{TRUE}.}

\item{trace}{Logical value. If \code{TRUE}, additional information 
is printed during the optimization. Default is \code{TRUE}.}

\item{theta.start}{Numeric vector comprising initial parameter values for the
vector of regression coefficients, the dispersion parameter, the power parameter 
and the variance of the random intercept (to be specified exactlyin this order!). 
Default is \code{NULL}: initial
parameter estimates are computed automatically by the function.}

\item{reltol}{Relative tolerance to be used in optim. Default to 1e-8}

\item{maxit}{Vector containing the maximum number of iterations used in optim by
the Nelder-Mead method and, if this fails, by the BFGS method}

\item{freq.updates}{Number of iterations after which the quadrature points are updated when the Nelder-Mead
algorithm is used for the optimization. Default value is 200. To update the quadrature points at every iteration 
(note that this may make the computation about 10x slower), set \code{freq.updates = 1} 
or \code{freq.updates = NA}. The function first tries to optimize the loglikelihood using the Nelder-Mead
algorithm, updating the quadrature points every \code{freq.updates} iterations. If this fails to converge,
a second attempt is made using the BFGS algorithm, for which the quadrature points are updated at every iteration.}

\item{min.var.init}{If the initial estimate of the variance of the random intercept is smaller than
this value, estimation is stopped and the user is advided to use the simpler Poisson-Tweedie GLM is used. Default is 1e-3.}
}
\value{
A list containing the following elements: function's call (\code{call}); 
maximum likelihood estimate (\code{mle});  value of the
loglikelihood at the mle (\code{logl}); \code{convergence} value (if 0, the optimization converged);
the observed Fisher information (\code{fisher.info}), if \code{hessian = T}; the number of quadrature points 
used (\code{quad.points}) and the starting value used in the optimization (\code{theta.init}); 
relevant warnings (\code{warnings}).
}
\description{
Estimates the Poisson-Tweedie generalized linear mixed model with random intercept.
Likelihood approximation for the model is based on the adaptive Gauss-Hermite quadrature rule.
}
\examples{
data(df1, package = 'ptmixed')
head(df1)

# 1) Quick example (just 1 quadrature point, hessian and SEs 
# not computed - NB: we recommend to increase the number of
# quadrature points to obtain much more accurate estimates,
# as shown in example 2 below where we use 5 quadrature points)

# estimate the model
fit1 = ptmixed(fixef.formula = y ~ group + time, id = id,
              offset = offset, data = df1, npoints = 1, 
              freq.updates = 200, hessian = FALSE, trace = TRUE)
              
# print summary:
summary(fit1, wald = FALSE)

\donttest{
# 2) Full computation that uses more quadrature points
# for the likelihood approximation and includes numeric
# evaluation of the hessian matrix

# estimate the model:
fit2 = ptmixed(fixef.formula = y ~ group + time, id = id,
              offset = offset, data = df1, npoints = 5, 
              freq.updates = 200, hessian = TRUE, trace = TRUE)
              
# print summary:
summary(fit2)

# extract summary:
results = summary(fit2)
ls(results)
results$coefficients
}
}
\seealso{
\code{\link{summary.ptglmm}}, \code{\link{ranef}}
}
\author{
Mirko Signorelli
}
