% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getseq.R
\name{species.kegg}
\alias{species.kegg}
\title{Convert Between Species Name and KEGG 3-Letter Code Format}
\usage{
species.kegg(organism, from = 'scientific')
}
\arguments{
\item{organism}{character string defining the organisms.}

\item{from}{string indicating the character of the provided name. It should be one of 'vulgar', 'scientific', '3-letter'.}
}
\value{
Returns a dataframe with the entries matching the request.
}
\description{
Converts between species name and KEGG 3-letter code format.
}
\examples{
\dontrun{species.kegg('chempanzee', from = 'vulgar')}
\dontrun{species.kegg('Pan paniscus')}
\dontrun{species.kegg('ppo', from = '3-letter')}
}
\seealso{
id.features(), species.mapping()
}
\author{
Juan Carlos Aledo
}
