% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{acc.dssp}
\alias{acc.dssp}
\title{Compute Residue Accessibility and SASA}
\usage{
acc.dssp(pdb, aa = 'all')
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file.}

\item{aa}{one letter code for the amino acid of interest, or 'all' for all the protein residues.}
}
\value{
A dataframe where each row is an individual residue of the selected protein. The variables computed, among others, are:
(i) the secondary structure (ss) element to which the residue belongs,
(ii) the solvent accessible surface area (sasa) of each residue in square angstrom (Å²), and
(iii) the accessibility (acc) computed as the percent of the sasa that the residue X would have in the tripeptide GXG with the polypeptide skeleton in an extended conformation and the side chain in the conformation most frequently observed in proteins.
}
\description{
Computes the accessibility as well as the SASA for each reside from the indicated protein.
}
\details{
You must have installed DSSP on your system and in the search path for executables.
}
\examples{
\dontrun{acc.dssp('3cwm')}
}
\references{
Miller et al (1987) J. Mol. Biol. 196: 641-656 (PMID: 3681970).

Touw et al (2015) Nucl. Ac. Res. 43(Database issue): D364-D368 (PMID: 25352545).
}
\seealso{
atom.dpx(), res.dpx(), str.part()
}
\author{
Juan Carlos Aledo
}
