% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{env.extract}
\alias{env.extract}
\title{Sequence Environment Around a Given Position}
\usage{
env.extract(prot, db = 'none', c, r, ctr = 'none', exclude = c())
}
\arguments{
\item{prot}{either a uniprot id or a string sequence.}

\item{db}{a character string specifying the desired database; it must be one of 'uniprot', 'metosite', 'none'.}

\item{c}{center of the environment.}

\item{r}{radius of the environment.}

\item{ctr}{the type of control environment; it must be one of 'random', 'closest', or 'none'.}

\item{exclude}{a vector containing the positions to be excluded as control.}
}
\value{
Returns a  list of two strings (environments).
}
\description{
Extracts the sequence environment around a given position.
}
\details{
The random control returns an environment center at a random position containing the same type or amino acid than the positive environment. The closest control searches for the closest position where such a type of amino acid is found and returns its environment.
}
\examples{
\dontrun{env.extract('P01009', db = 'uniprot', 271, 10, ctr = 'random')}
}
\references{
Aledo et al. Sci Rep. 2015; 5: 16955. (PMID: 26597773)
}
\seealso{
env.matrices(), env.Ztest() and env.plot()
}
\author{
Juan Carlos Aledo
}
