% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolutionary.R
\name{custom.aln}
\alias{custom.aln}
\title{Download and Align Orthologous Sequences}
\usage{
custom.aln(target, species, molecule = 'protein', sfile = FALSE)
}
\arguments{
\item{target}{the KEGG identifier of the protein of interest.}

\item{species}{a character vector containing the KEGG code for the species of interest.}

\item{molecule}{a character string specifying the nature of the sequence; it must be one of 'dna', 'protein'.}

\item{sfile}{logical, if TRUE the alignment in fasta format is saved in the current directory.}
}
\value{
Returns a list of class "fasta" with three components: 'ali' (an alignment character matrix with a row per sequence and a column per residue), 'id' (sequence identifiers) and 'call' (the matched call).
}
\description{
Downloads orthologous sequences and carries out their alignment
}
\details{
We can build the list of species or, alternatively, we can choose between four pre-established options: 'vertebrates', 'plants','one-hundred' and 'two-hundred'. The first will use the following seven species: human (hsa), chimp (ptr), gorilla (ggo), rat (rno), cow (bta), chicken (gga), western clawed frog (xtr) and zebrafish (dre). The second, A. thaliana (ara), A. lyrata (aly), B. oleracea (boe), G. max (gmax), S. lycopersicum (sly), O. sativa (osa) and C. reinhardtii (cre). The third and fourth options will use orthologous sequences from one hundred and two hundred different species, respectively.
}
\examples{
\dontrun{custom.aln('hsa:4069', species = c('pps', 'pon', 'mcc', 'ssc'))}
\dontrun{custom.aln('cge:100773737', 'vertebrates', molecule = 'dna' )}
}
\references{
Edgar RC. Nucl. Ac. Res. 2004 32:1792-1797.

Edgar RC. BMC Bioinformatics 5(1):113.
}
\seealso{
msa(), list.hom(), parse.hssp(), get.hssp(), shannon()
}
\author{
Juan Carlos Aledo
}
