% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dssp.R
\name{compute.dssp}
\alias{compute.dssp}
\title{Compute and Return a DSSP File}
\usage{
compute.dssp(pdb, destfile = './')
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file.}

\item{destfile}{a character string with the path where the DSSP file is going to be saved.}
}
\value{
an online computed dssp file that is saved at the indicated location.
}
\description{
Computes and returns a DSSP file.
}
\details{
A drawback of this function is that it depends on DSSP's server and in occasions it can take a long time to process the request.
}
\examples{
\dontrun{compute.dssp(pdb = '3cwm', destfile = './')}
}
\references{
Touw et al (2015) Nucl. Ac. Res. 43(Database issue): D364-D368 (PMID: 25352545).
}
\seealso{
download.dssp(), parse.dssp(), mkdssp() and acc.dssp()
}
\author{
Juan Carlos Aledo
}
