% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa.R
\name{aa.comp}
\alias{aa.comp}
\title{Amino Acid Composition}
\usage{
aa.comp(target, uniprot = TRUE)
}
\arguments{
\item{target}{a character string specifying the UniProt ID of the protein of interest or, alternatively, the sequence of that protein.}

\item{uniprot}{logical, if TRUE the argument 'target' should be an ID.}
}
\value{
Returns a dataframe with the absolute frequency of each type of residue found in the target peptide.
}
\description{
Returns a table with the amino acid composition of the target protein.
}
\examples{
aa.comp('MPSSVSWGILLLAGLCCLVPVSLAEDPQGDAAQK', uniprot = FALSE)
aa.comp('P01009')
}
\seealso{
is.at(), renum.pdb(), renum.meto(), renum(), aa.at()
}
\author{
Juan Carlos Aledo
}
