% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{gibbs_sldax}
\alias{gibbs_sldax}
\title{Fit supervised or unsupervised topic models (SLDAX or LDA)}
\usage{
gibbs_sldax(
  formula,
  data,
  m = 100,
  burn = 0,
  thin = 1,
  docs,
  V,
  K = 2L,
  model = c("lda", "slda", "sldax", "slda_logit", "sldax_logit"),
  sample_beta = TRUE,
  sample_theta = TRUE,
  interaction_xcol = -1L,
  alpha_ = 1,
  gamma_ = 1,
  mu0 = NULL,
  sigma0 = NULL,
  a0 = NULL,
  b0 = NULL,
  eta_start = NULL,
  constrain_eta = FALSE,
  proposal_sd = NULL,
  return_assignments = FALSE,
  correct_ls = TRUE,
  verbose = FALSE,
  display_progress = FALSE
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats:formula]{formula}}: a symbolic
description of the model to be fitted.}

\item{data}{An optional data frame containing the variables in the model.}

\item{m}{The number of iterations to run the Gibbs sampler (default: \code{100}).}

\item{burn}{The number of iterations to discard as the burn-in period
(default: \code{0}).}

\item{thin}{The period of iterations to keep after the burn-in period
(default: \code{1}).}

\item{docs}{A D x max(\eqn{N_d}) matrix of word indices for all documents.}

\item{V}{The number of unique terms in the vocabulary.}

\item{K}{The number of topics.}

\item{model}{A string denoting the type of model to fit. See 'Details'.
(default: \code{"lda"}).}

\item{sample_beta}{A logical (default = \code{TRUE}): If \code{TRUE}, the
topic-vocabulary distributions are sampled from their full conditional
distribution.}

\item{sample_theta}{A logical (default = \code{TRUE}): If \code{TRUE}, the
topic proportions will be sampled. CAUTION: This can be memory-intensive.}

\item{interaction_xcol}{EXPERIMENTAL: The column number of the design matrix
for the additional predictors for which an interaction with the \eqn{K}
topics is desired (default: \code{-1L}, no interaction). Currently only supports
a single continuous predictor or a two-category categorical predictor
represented as a single dummy-coded column.}

\item{alpha_}{The hyper-parameter for the prior on the topic proportions
(default: \code{1.0}).}

\item{gamma_}{The hyper-parameter for the prior on the topic-specific
vocabulary probabilities (default: \code{1.0}).}

\item{mu0}{An optional q x 1 mean vector for the prior on the regression
coefficients. See 'Details'.}

\item{sigma0}{A q x q variance-covariance matrix for the prior on the
regression coefficients. See 'Details'.}

\item{a0}{The shape parameter for the prior on sigma2 (default: \code{0.001}).}

\item{b0}{The scale parameter for the prior on sigma2 (default: \code{0.001}).}

\item{eta_start}{A q x 1 vector of starting values for the
regression coefficients.}

\item{constrain_eta}{A logical (default = \code{FALSE}): If \code{TRUE}, the
regression coefficients will be constrained so that they are in descending
order; if \code{FALSE}, no constraints will be applied.}

\item{proposal_sd}{The proposal standard deviations for drawing the
regression coefficients, N(0, proposal_sd(j)), \eqn{j = 1, \ldots, q}.
Only used for \code{model = "slda_logit"} and
\code{model = "sldax_logit"} (default: \code{2.38} for all coefficients).}

\item{return_assignments}{A logical (default = \code{FALSE}): If
\code{TRUE}, returns an N x \eqn{max N_d} x M array of topic assignments
in slot \verb{@topics}. CAUTION: this can be memory-intensive.}

\item{correct_ls}{Run Stephens (2000) label switching correct algorithm on
posterior? (default = \code{TRUE}).}

\item{verbose}{Should parameter draws be output during sampling? (default:
\code{FALSE}).}

\item{display_progress}{Show progress bar? (default: \code{FALSE}). Do not use
with \code{verbose = TRUE}.}
}
\value{
An object of class \linkS4class{Sldax}.
}
\description{
\code{gibbs_sldax()} is used to fit both supervised and unsupervised topic models.
}
\details{
The number of regression coefficients q in supervised topic models is
determined as follows: For the SLDA model with only the \eqn{K} topics as
predictors, \eqn{q = K}; for the SLDAX model with \eqn{K} topics and \eqn{p}
additional predictors, there are two possibilities: (1) If no interaction
between an additional covariate and the \eqn{K} topics is desired
(default: \code{interaction_xcol = -1L}), \eqn{q = p + K}; (2) if an
interaction between an additional covariate and the \eqn{K} topics is desired
(e.g., \code{interaction_xcol = 1}), \eqn{q = p + 2K - 1}. If you supply
custom values for prior parameters \code{mu0} or \code{sigma0}, be sure that
the length of \code{mu0} (\eqn{q}) and/or the number of rows and columns of
\code{sigma0} (\eqn{q \times q}) are correct. If you supply custom starting
values for \code{eta_start}, be sure that the length of \code{eta_start} is
correct.

For \code{model}, one of \code{c("lda", "slda", "sldax", "slda_logit", "sldax_logit")}.
\itemize{
\item \code{"lda"}: unsupervised topic model;
\item \code{"slda"}: supervised topic model with a continuous outcome;
\item \code{"sldax"}: supervised topic model with a continuous outcome and
additional predictors of the outcome;
\item \code{"slda_logit"}: supervised topic model with a dichotomous outcome (0/1);
\item \code{"sldax_logit"}: supervised topic model with a dichotomous outcome (0/1)
and additional predictors of the outcome.
}

For \code{mu0}, the first \eqn{p} elements correspond to coefficients for the
\eqn{p} additional predictors (if none, \eqn{p = 0}), while elements
\eqn{p + 1} to \eqn{p + K} correspond to coefficients for the \eqn{K} topics,
and elements \eqn{p + K + 1} to \eqn{p + 2K - 1} correspond to coefficients
for the interaction (if any) between one additional predictor and the \eqn{K}
topics. By default, we use a vector of \eqn{q} \code{0}s.

For \code{sigma0}, the first \eqn{p} rows/columns correspond to coefficients
for the \eqn{p} additional predictors (if none, \eqn{p = 0}), while
rows/columns \eqn{p + 1} to \eqn{p + K} correspond to coefficients for the
\eqn{K} topics, and rows/columns \eqn{p + K + 1} to \eqn{p + 2K - 1}
correspond to coefficients for the interaction (if any) between one
additional predictor and the \eqn{K} topics. By default, we use an identity
matrix for \code{model = "slda"} and \code{model = "sldax"} and a diagonal
matrix with diagonal elements (variances) of \code{6.25} for
\code{model = "slda_logit"} and \code{model = "sldax_logit"}.
}
\examples{
library(lda) # Required if using `prep_docs()`

data(teacher_rate)  # Synthetic student ratings of instructors
docs_vocab <- prep_docs(teacher_rate, "doc")
vocab_len <- length(docs_vocab$vocab)
m1 <- gibbs_sldax(rating ~ I(grade - 1), m = 2,
                  data = teacher_rate, docs = docs_vocab$documents,
                  V = vocab_len, K = 2, model = "sldax")

}
\seealso{
Other Gibbs sampler: 
\code{\link{gibbs_logistic}()},
\code{\link{gibbs_mlr}()}
}
\concept{Gibbs sampler}
