% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{get_R2.glm}
\alias{get_R2.glm}
\title{Pseudo-R-squared for Logistic Models.}
\usage{
\method{get_R2}{glm}(fit, method = "nakagawa", ...)
}
\arguments{
\item{fit}{A logistic model.}

\item{method}{Can be \link[=R2_nakagawa]{"nakagawa"} or \link[=R2_tjur]{"tjur"}.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Pseudo-R-squared for Logistic Models.
}
\examples{
\dontrun{
library(psycho)

fit <- glm(vs ~ wt, data = mtcars, family = "binomial")
fit <- glm(Sex ~ Adjusting, data = psycho::affective, family = "binomial")

get_R2(fit)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
